**************************************************************************************************************************************************
******************* Code for 'Does monetary policy affect non-mining business investment in Australia? evidence from BLADE' *******************
***********************************************************************************************************************

**************************************************DATE: 27 Nov 2023 ******************************************************************************
**************************************************** AUTHOR: Gulnara Nolan and Jonathan Hambur *******************************************************************
*********************************************************************************************************************************************

*** Code strcuture
*01 Define leaders
*02 Quarter based regs
*03 Quarter based regs lagged
*04 annual; based regs 
*05 annual; based regs lagged
*06 TEST DIFF

adopath + ""
mata: mata mlib index

cd "${intermediates}"
use bas_final3.dta, clear



tsset firmid2 period

local hmax = 16

eststo clear 

cap drop b u d Years Zero
gen Years= _n-1 if _n<=`hmax'+1
g Zero=0 if _n<=`hmax'+1
gen b=0
gen u=0
gen d=0




*******************************
*****01 Define leaders
** quarter income based
bys ind period: egen income_95= pctile(turnover), p(95)

gen leader=(turnover>income_95 & turnover!=.)
tsset firmid2 period

g leader_l = l4.leader
*/
** Annual based income
preserve
tempfile annual_in

collapse(sum) turnover, by(firmid2 tsid)
rename turnover an_to
tsset firmid2 tsid
g l_an_to = l.an_to
save `annual_in'
restore

merge m:1 firmid2 tsid using `annual_in', keep(master match) nogen

bys ind tsid: egen income_ann_95= pctile(an_to), p(95)
bys ind tsid: egen income_lann_95= pctile(l_an_to), p(95)

gen leader_ann=(an_to>income_ann_95 & an_to!=.)
gen leader_ann_l=(l_an_to>income_lann_95 & l_an_to!=.)

tsset firmid2 period


eststo clear 

*******02 Quarter based regs

forv h=0/16 {
	eststo: reghdfe intmargin_`h' l(0/1).beckers_aug l(1/1).intmargin l(1/1).gdp l(1/1).cpi l(1/1).dsales if leader==1, cluster (period firmid2) a(fsize_ ind qr)
}

estout * using "${results}\intmargin_bas_leader.csv", replace	cells(b(star) se ci_l ci_u) stats(r2 N) 



eststo clear 
forv h=0/16 {
	eststo: reghdfe extmargin_`h' l(0/1).beckers_aug l(1/1).extmargin l(1/1).gdp l(1/1).cpi l(1/1).dsales if leader==1  , cluster (period firmid2) a(fsize_ ind qr)
}

estout * using "${results}\extmargin_bas_leader.csv", replace	cells(b(star) se ci_l ci_u) stats(r2 N)




eststo clear 
forv h=0/16 {
	eststo: reghdfe intmargin_`h' l(0/1).beckers_aug l(1/1).intmargin l(1/1).gdp l(1/1).cpi l(1/1).dsales if leader==0, cluster (period firmid2) a(fsize_ ind qr)
}

estout * using "${results}\intmargin_bas_nonleader.csv", replace	cells(b(star) se ci_l ci_u) stats(r2 N) 



eststo clear 
forv h=0/16 {
	eststo: reghdfe extmargin_`h' l(0/1).beckers_aug l(1/1).extmargin l(1/1).gdp l(1/1).cpi l(1/1).dsales if leader==0 , cluster (period firmid2) a(fsize_ ind qr)
}

estout * using "${results}\extmargin_bas_nonleader.csv", replace	cells(b(star) se ci_l ci_u) stats(r2 N)



*******03 Quarter based regs lagged

forv h=0/16 {
	eststo: reghdfe intmargin_`h' l(0/1).beckers_aug l(1/1).intmargin l(1/1).gdp l(1/1).cpi l(1/1).dsales if leader_l==1, cluster (period firmid2) a(fsize_ ind qr)
}

estout * using "${results}\intmargin_bas_leader_l.csv", replace	cells(b(star) se ci_l ci_u) stats(r2 N) 



eststo clear 
forv h=0/16 {
	eststo: reghdfe extmargin_`h' l(0/1).beckers_aug l(1/1).extmargin l(1/1).gdp l(1/1).cpi l(1/1).dsales if leader_l==1  , cluster (period firmid2) a(fsize_ ind qr)
}

estout * using "${results}\extmargin_bas_leader_l.csv", replace	cells(b(star) se ci_l ci_u) stats(r2 N)




eststo clear 
forv h=0/16 {
	eststo: reghdfe intmargin_`h' l(0/1).beckers_aug l(1/1).intmargin l(1/1).gdp l(1/1).cpi l(1/1).dsales if leader_l==0, cluster (period firmid2) a(fsize_ ind qr)
}

estout * using "${results}\intmargin_bas_nonleader_l.csv", replace	cells(b(star) se ci_l ci_u) stats(r2 N) 



eststo clear 
forv h=0/16 {
	eststo: reghdfe extmargin_`h' l(0/1).beckers_aug l(1/1).extmargin l(1/1).gdp l(1/1).cpi l(1/1).dsales if leader_l==0 , cluster (period firmid2) a(fsize_ ind qr)
}

estout * using "${results}\extmargin_bas_nonleader_l.csv", replace	cells(b(star) se ci_l ci_u) stats(r2 N)




*******04 annual; based regs 

forv h=0/16 {
	eststo: reghdfe intmargin_`h' l(0/1).beckers_aug l(1/1).intmargin l(1/1).gdp l(1/1).cpi l(1/1).dsales if leader_ann==1, cluster (period firmid2) a(fsize_ ind qr)
}

estout * using "${results}\intmargin_bas_leader_ann.csv", replace	cells(b(star) se ci_l ci_u) stats(r2 N) 



eststo clear 
forv h=0/16 {
	eststo: reghdfe extmargin_`h' l(0/1).beckers_aug l(1/1).extmargin l(1/1).gdp l(1/1).cpi l(1/1).dsales if leader_ann==1  , cluster (period firmid2) a(fsize_ ind qr)
}

estout * using "${results}\extmargin_bas_leader_ann.csv", replace	cells(b(star) se ci_l ci_u) stats(r2 N)




eststo clear 
forv h=0/16 {
	eststo: reghdfe intmargin_`h' l(0/1).beckers_aug l(1/1).intmargin l(1/1).gdp l(1/1).cpi l(1/1).dsales if leader_ann==0, cluster (period firmid2) a(fsize_ ind qr)
}

estout * using "${results}\intmargin_bas_nonleader_ann.csv", replace	cells(b(star) se ci_l ci_u) stats(r2 N) 



eststo clear 
forv h=0/16 {
	eststo: reghdfe extmargin_`h' l(0/1).beckers_aug l(1/1).extmargin l(1/1).gdp l(1/1).cpi l(1/1).dsales if leader_ann==0 , cluster (period firmid2) a(fsize_ ind qr)
}

estout * using "${results}\extmargin_bas_nonleader_ann.csv", replace	cells(b(star) se ci_l ci_u) stats(r2 N)



*******05 annual; based regs lagged

forv h=0/16 {
	eststo: reghdfe intmargin_`h' l(0/1).beckers_aug l(1/1).intmargin l(1/1).gdp l(1/1).cpi l(1/1).dsales if leader_ann_l==1, cluster (period firmid2) a(fsize_ ind qr)
}

estout * using "${results}\intmargin_bas_leader_ann_l.csv", replace	cells(b(star) se ci_l ci_u) stats(r2 N) 



eststo clear 
forv h=0/16 {
	eststo: reghdfe extmargin_`h' l(0/1).beckers_aug l(1/1).extmargin l(1/1).gdp l(1/1).cpi l(1/1).dsales if leader_ann_l==1  , cluster (period firmid2) a(fsize_ ind qr)
}

estout * using "${results}\extmargin_bas_leader_ann_l.csv", replace	cells(b(star) se ci_l ci_u) stats(r2 N)




eststo clear 
forv h=0/16 {
	eststo: reghdfe intmargin_`h' l(0/1).beckers_aug l(1/1).intmargin l(1/1).gdp l(1/1).cpi l(1/1).dsales if leader_ann_l==0, cluster (period firmid2) a(fsize_ ind qr)
}

estout * using "${results}\EXTmargin_bas_nonleader_ann_l.csv", replace	cells(b(star) se ci_l ci_u) stats(r2 N) 



eststo clear 
forv h=0/16 {
	eststo: reghdfe extmargin_`h' l(0/1).beckers_aug l(1/1).extmargin l(1/1).gdp l(1/1).cpi l(1/1).dsales if leader_ann_l==0 , cluster (period firmid2) a(fsize_ ind qr)
}

estout * using "${results}\extmargin_bas_nonleader_ann_l.csv", replace	cells(b(star) se ci_l ci_u) stats(r2 N)

*/

**06 TEST DIFF
*** testing difference between leaders and non-leaders
foreach var in leader_l leader leader_ann leader_ann_l {
eststo clear 
forv h=0/16 {
	eststo: reghdfe intmargin_`h' i.`var'##(l(0/1).c.beckers_aug l(1/1).c.intmargin l(1/1).c.gdp l(1/1).c.cpi l(1/1).c.dsales) , cluster (period firmid2) a(i.`var'##i.fsize_ i.`var'##i.ind i.`var'##i.qr)
}

estout * using "${results}\test_`var'int.csv", replace	cells(b(star) se ci_l ci_u) stats(r2 N) 



eststo clear 
forv h=0/16 {
	eststo: reghdfe extmargin_`h' i.`var'##(l(0/1).c.beckers_aug l(1/1).c.extmargin l(1/1).c.gdp l(1/1).c.cpi l(1/1).c.dsales) , cluster (period firmid2) a(i.`var'##i.fsize_ i.`var'##i.ind i.`var'##i.qr)
}


estout * using "${results}\test_`var'_ext.csv", replace	cells(b(star) se ci_l ci_u) stats(r2 N)

}